<?php

namespace App\Http\Controllers\Services;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\DashboardController;
use niklasravnsborg\LaravelPdf\Facades\Pdf;
//use niklasravnsborg\LaravelPdf\Facades\Pdf;

class ExportPDFController extends Controller
{
    /**
     * [Description for exportTransfer]
     *
     * @return [type]
     * 
     */
    function exportTransfer() {
        $dashboard = new DashboardController();
        $transfers = $dashboard->listTransfers();
        $pdf = Pdf::loadView('exportPDF.pdf.transfer', [
           'transfers'=>$transfers
        ], [], 
       
        [
            'title' => 'Certificate',
            'format' => 'A4-P',
            'orientation' => 'P'
        ]);
      
        return $pdf->stream('transfers.pdf');
    }
    /**
     * [for exportCoupons]
     *
     * @return [type]
     * 
     */
    function exportCoupons() {
        $dashboard = new DashboardController();
        $coupons = $dashboard->listCoupons();
        $pdf = Pdf::loadView('exportPDF.pdf.coupons', [
           'coupons'=>$coupons
        ], [], 
       
        [
            'title' => 'Certificate',
            'format' => 'A4-P',
            'orientation' => 'P'
        ]);
      
        return $pdf->stream('coupons.pdf');
    }
    /**
     * [For exportDraws]
     *
     * @return [file]
     * 
     */
    function exportDraws() {
        $dashboard = new DashboardController();
        $draws = $dashboard->listDraws();
        $pdf = Pdf::loadView('exportPDF.pdf.draws', [
           'draws'=>$draws
        ], [], 
       
        [
            'title' => 'Certificate',
            'format' => 'A4-P',
            'orientation' => 'P'
        ]);
      
        return $pdf->stream('draws.pdf');
    }
    /**
     * [Description for exportSupplies]
     *
     * @return [type]
     * 
     */
    function exportSupplies() {
        $dashboard = new DashboardController();
        $supplies = $dashboard->listٍSupplies();
        $pdf = Pdf::loadView('exportPDF.pdf.supplies', [
           'supplies'=>$supplies
        ], [], 
       
        [
            'title' => 'Certificate',
            'format' => 'A4-P',
            'orientation' => 'P'
        ]);
      
        return $pdf->stream('supplies.pdf');
    }
    /**
     * [Description for exportSupplies]
     *
     * @return [type]
     * 
     */
    function exportBuying() {
        $dashboard = new DashboardController();
        $buying = $dashboard->listBuying();
        $pdf = Pdf::loadView('exportPDF.pdf.buying', [
           'buying'=>$buying
        ], [], 
       
        [
            'title' => 'Certificate',
            'format' => 'A4-P',
            'orientation' => 'P'
        ]);
      
        return $pdf->stream('buying.pdf');
    }

    public function exportExchange()
    {
        $dashboard = new DashboardController();
        $exchanges = $dashboard->listExchanges();
        $pdf = Pdf::loadView('exportPDF.pdf.exchanges', [
           'exchanges'=>$exchanges
        ], [], 
       
        [
            'title' => 'Certificate',
            'format' => 'A4-P',
            'orientation' => 'P'
        ]);
      
        return $pdf->stream('exchanges.pdf');
    }
}
